#ifndef CE2_TST_DH_H
#define CE2_TST_DH_H

/*
* All the includes that are needed for code using this module to
* compile correctly should be #included here.
*/

#include "CE2_TST_Config.h"

#ifdef __cplusplus
extern "C"
{
#endif


/*
*  Object %name    : %
*  State           :  %state%
*  Creation date   :  Wen Mar 20 10:17:10 2007
*  Last modified   :  %modify_time%
*/
/** @file
*  \brief A brief description of this module
*
*  \version CE2_TST_DH.h#1:incl:1
*  \author Yermalayeu Ihar
*  \remarks Copyright (C) 2006 by Discretix Technologies Ltd.
*           All Rights reserved
*/

/************************ Defines *******************************/

#define TST_MAX_DH_KEY_SIZE 1024
#define TST_NAME_STRING_LEN 150
#define TST_DH_SECRET_DATA_GEN_TYPES 2
#define TST_DH_ANSI924_DERIVATION_MODES 2
#define TST_DH_HYBRID_MODE 1
#define TST_DH_NON_HYBRID_MODE 0
#define TST_DH_GET_SECRET_KEY_ASN1 0

/************************ Enums *********************************/
/************************ Typedefs  *****************************/
/************************ Structs  ******************************/

typedef struct TST_DH_TestDataStructPKCS3{	
  char					    TST_Name[TST_NAME_STRING_LEN];
  DxUint8_t		 				TST_Generator[TST_MAX_DH_KEY_SIZE];
  DxUint16_t		 			TST_GeneratorSize;	
  DxUint8_t 					TST_Prime[TST_MAX_DH_KEY_SIZE];
  DxUint16_t 					TST_PrimeSize;
  DxUint16_t 					TST_L; 
} TST_DH_TestDataStructPKCS3;

typedef struct TST_DH_TestDataStructANSI942{	
  char					    TST_Name[TST_NAME_STRING_LEN];
  DxUint8_t		 				TST_Generator[TST_MAX_DH_KEY_SIZE];
  DxUint16_t		 			TST_GeneratorSize;	
  DxUint8_t 					TST_Prime[TST_MAX_DH_KEY_SIZE];
  DxUint16_t 					TST_PrimeSize;
  DxUint8_t 					TST_Q[TST_MAX_DH_KEY_SIZE];
  DxUint16_t 					TST_QSize; 
  CE2_DH_HASH_OpMode_t 		TST_hashFunc;
  CE2_DH_DerivationFunc_Mode TST_DerFunc_mode;
  DxUint16_t				    TST_KeyLenInBits;	
} TST_DH_TestDataStructANSI942;

/************************ Public Variables **********************/

extern TST_DH_TestDataStructPKCS3   TST_DH_Acceptance_PKCS3_TestDataStruct[];
extern TST_DH_TestDataStructANSI942 TST_DH_Acceptance_ANSI942_TestDataStruct[];
extern const int	TST_NumberOf_DH_PKCS3_AcceptanceTests;
extern const int	TST_NumberOf_DH_ANSI942_AcceptanceTests;

/************************ Public Functions **********************/

/*****************************************************************************
* Function Name:                                                           
* 	CE2_ATP_TST_DH_Acceptance_PKCS3 		
* 
* Inputs:
* 	out - pointer to output log file;
*
* Outputs:
* 	CE2Error_t - Function error return		    					  		
*
* Description:																	
* 	This function Is a Acceptance test for the Diffie-Hellman key agreement 
*  scheme according to PKCS#3 
* 	Prime sizes used (in bits) - 512/1024/2048									
* 	Generator sizes used (in bits) - 512/1024/2048
* 	L sizes used - 10/11/12 
*
* Algorithm:		
* 1. Call the CE2_DH_PKCS3_GeneratePubPrv function to 
*    generate a public and privet key for the client
* 2. Call the CE2_DH_PKCS3_GeneratePubPrv function to 
*    generate a public and privet key for the Server
* 3. Call the CE2_DH_PKCS3_GetSecretKey function to 
*    generate a secret key for the client	
* 4. Call the CE2_DH_PKCS3_GetSecretKey function to 
*    generate a secret key for the Server
* 5. Compare the two secret key - to verify they are identical													
*
******************************************************************************/
CE2Error_t CE2_ATP_TST_DH_Acceptance_PKCS3(FILE* out);

/*****************************************************************************
* Function Name:                                                           
* 	CE2_ATP_TST_DH_Acceptance_ANSI9_42 		
* 
* Inputs:
* 	out - pointer to output log file;
*
* Outputs:
* 	CE2Error_t - Function error return		    					  		
*
* Description:																	
* 	This function Is a Acceptance test for the Diffie-Hellman key agreement 
*  schemes according to ANSI9.42 
*  using two methods for getting the secret data 
*  and using two methods for key derivation
* 	Prime sizes used (in bits) - 512/1024/2048									
* 	Generator sizes used (in bits) - 512/1024/2048
* 	Q sizes used (in bits) - 512/1024/2048
*  Derived Key sizes (in bits) - 128/192/256
*
* Algorithm:		
* 1. Call the CE2_DH_ANSI_X942_GeneratePubPrv function to 
*    generate a public and privet key for the client
* 2. Call the CE2_DH_ANSI_X942_GeneratePubPrv function to 
*    generate a public and privet key for the Server
* 3. Repete steps 1 & 2 in case of Hybrid scheam
* 4. Call the CE2_DH_X942_GetSecret_ASN1_2_Data
*             or 
* 	       CE2_DH_X942_GetSecret_Concat_2_Data
*             and in case of Hybrid scheam
*             CE2_DH_X942_Hybrid_GetSecret_ASN1_2_Data
*             or 
*             CE2_DH_X942_Hybrid_GetSecret_Concat_2_Data
*     both for the server and the Client to generate the secret keys
* 5. Compare the two secret keys - to verify they are identical													
*
******************************************************************************/
CE2Error_t CE2_ATP_TST_DH_Acceptance_ANSI942(FILE* out);

#ifdef __cplusplus
}
#endif

#endif /* CE2_TST_DH_H */
